/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.event.common;

import io.github.fabricators_of_create.porting_lib.block.CustomExpBlock;
import io.github.fabricators_of_create.porting_lib.core.event.BaseEvent;
import io.github.fabricators_of_create.porting_lib.tool.ToolAction;
import io.github.fabricators_of_create.porting_lib.util.PortingHooks;
import java.util.EnumSet;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4538;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockEvents
extends BaseEvent {
    public static final Event<BlockBreak> BLOCK_BREAK = EventFactory.createArrayBacked(BlockBreak.class, callbacks -> event -> {
        for (BlockBreak e : callbacks) {
            e.onBlockBreak(event);
        }
    });
    public static final Event<NotifyNeighbors> NEIGHBORS_NOTIFY = EventFactory.createArrayBacked(NotifyNeighbors.class, callbacks -> event -> {
        for (NotifyNeighbors e : callbacks) {
            e.onNotifyNeighbors(event);
        }
    });
    public static final Event<BlockModification> BLOCK_MODIFICATION = EventFactory.createArrayBacked(BlockModification.class, callbacks -> event -> {
        for (BlockModification e : callbacks) {
            e.onBlockModification(event);
        }
    });
    public static final Event<BeforePlace> BEFORE_PLACE = EventFactory.createArrayBacked(BeforePlace.class, callbacks -> context -> {
        for (BeforePlace callback : callbacks) {
            class_1269 result = callback.beforePlace(context);
            if (result == null) continue;
            return result;
        }
        return null;
    });
    @Deprecated
    public static final Event<AfterPlace> AFTER_PLACE = EventFactory.createArrayBacked(AfterPlace.class, callbacks -> context -> {
        for (AfterPlace callback : callbacks) {
            callback.afterPlace(context);
        }
    });
    public static final Event<PostProcessPlace> POST_PROCESS_PLACE = EventFactory.createArrayBacked(PostProcessPlace.class, callbacks -> (context, blockPos, blockState) -> {
        for (PostProcessPlace callback : callbacks) {
            callback.postProcessPlace(context, blockPos, blockState);
        }
    });
    private final class_1936 level;
    private final class_2338 pos;
    private final class_2680 state;

    public BlockEvents(class_1936 world, class_2338 pos, class_2680 state) {
        this.pos = pos;
        this.level = world;
        this.state = state;
    }

    public class_1936 getLevel() {
        return this.level;
    }

    @Deprecated(forRemoval=true)
    public class_1936 getWorld() {
        return this.level;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public class_2680 getState() {
        return this.state;
    }

    public static interface PostProcessPlace {
        public void postProcessPlace(class_1750 var1, class_2338 var2, class_2680 var3);
    }

    public static interface AfterPlace {
        public void afterPlace(class_1750 var1);
    }

    public static interface BeforePlace {
        @Nullable
        public class_1269 beforePlace(class_1750 var1);
    }

    @FunctionalInterface
    public static interface BlockModification {
        public void onBlockModification(BlockToolModificationEvent var1);
    }

    public static class BlockToolModificationEvent
    extends BlockEvents {
        private final class_1838 context;
        private final ToolAction toolAction;
        private final boolean simulate;
        private class_2680 state;

        public BlockToolModificationEvent(class_2680 originalState, @NotNull class_1838 context, ToolAction toolAction, boolean simulate) {
            super((class_1936)context.method_8045(), context.method_8037(), originalState);
            this.context = context;
            this.state = originalState;
            this.toolAction = toolAction;
            this.simulate = simulate;
        }

        @Nullable
        public class_1657 getPlayer() {
            return this.context.method_8036();
        }

        public class_1799 getHeldItemStack() {
            return this.context.method_8041();
        }

        public ToolAction getToolAction() {
            return this.toolAction;
        }

        public boolean isSimulated() {
            return this.simulate;
        }

        @NotNull
        public class_1838 getContext() {
            return this.context;
        }

        public void setFinalState(@Nullable class_2680 finalState) {
            this.state = finalState;
        }

        public class_2680 getFinalState() {
            return this.state;
        }

        public void sendEvent() {
            ((BlockModification)BLOCK_MODIFICATION.invoker()).onBlockModification(this);
        }
    }

    @FunctionalInterface
    public static interface NotifyNeighbors {
        public void onNotifyNeighbors(NeighborNotifyEvent var1);
    }

    public static class NeighborNotifyEvent
    extends BlockEvents {
        private final EnumSet<class_2350> notifiedSides;
        private final boolean forceRedstoneUpdate;

        public NeighborNotifyEvent(class_1937 level, class_2338 pos, class_2680 state, EnumSet<class_2350> notifiedSides, boolean forceRedstoneUpdate) {
            super((class_1936)level, pos, state);
            this.notifiedSides = notifiedSides;
            this.forceRedstoneUpdate = forceRedstoneUpdate;
        }

        public EnumSet<class_2350> getNotifiedSides() {
            return this.notifiedSides;
        }

        public boolean getForceRedstoneUpdate() {
            return this.forceRedstoneUpdate;
        }

        public void sendEvent() {
            ((NotifyNeighbors)NEIGHBORS_NOTIFY.invoker()).onNotifyNeighbors(this);
        }
    }

    @FunctionalInterface
    public static interface BlockBreak {
        public void onBlockBreak(BreakEvent var1);
    }

    public static class BreakEvent
    extends BlockEvents {
        private final class_1657 player;
        private int exp;

        public BreakEvent(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
            super((class_1936)world, pos, state);
            this.player = player;
            if (state == null || !PortingHooks.isCorrectToolForDrops(state, player)) {
                this.exp = 0;
            } else {
                int n;
                int bonusLevel = class_1890.method_8225((class_1887)class_1893.field_9130, (class_1799)player.method_6047());
                int silklevel = class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)player.method_6047());
                class_2248 class_22482 = state.method_26204();
                if (class_22482 instanceof CustomExpBlock) {
                    CustomExpBlock exp = (CustomExpBlock)class_22482;
                    n = exp.getExpDrop(state, (class_4538)world, world.method_8409(), pos, bonusLevel, silklevel);
                } else {
                    n = 0;
                }
                this.exp = n;
            }
        }

        public class_1657 getPlayer() {
            return this.player;
        }

        public int getExpToDrop() {
            return this.isCanceled() ? 0 : this.exp;
        }

        public void setExpToDrop(int exp) {
            this.exp = exp;
        }

        public void sendEvent() {
            ((BlockBreak)BLOCK_BREAK.invoker()).onBlockBreak(this);
        }
    }
}

